(function() {
  $('.modal-btn').on('click', function() {
    console.log($(this).attr('data-modal'));
    var modalEl = document.querySelector($(this).attr('data-modal')),
        revealer = new RevealFx(modalEl),
        closeCtrl = modalEl.querySelector('.btn--modal-close');
        console.log(modalEl);
    modalEl.classList.add('modal--open');
    $('.overlay').addClass('over-open');
    $('body').addClass('no-scroll');
    revealer.reveal({
      bgcolor: '#d6312b',
      direction: 'lr',
      duration: 400,
      easing: 'easeOutCirc',
      onCover: function(contentEl, revealerEl) {
        contentEl.style.opacity = 1;
      },
      onComplete: function() {
        closeCtrl.addEventListener('click', function(ev) {
          revealer.reveal({
            bgcolor: '#444',
            direction: 'rl',
            duration: 400,
            easing: 'easeOutCirc',
            onCover: function(contentEl, revealerEl) {
              modalEl.classList.remove('modal--open');
              $('.overlay').removeClass('over-open');
              $('body').removeClass('no-scroll');
            }
          });
        });
        document.body.addEventListener('keyup', function(e) {
          if(e.key == "Escape"){
            revealer.reveal({
              bgcolor: '#444',
              direction: 'rl',
              duration: 400,
              easing: 'easeOutCirc',
              onCover: function(contentEl, revealerEl) {
                modalEl.classList.remove('modal--open');
                $('.overlay').removeClass('over-open');
                $('body').removeClass('no-scroll');
              }
            });
          }
        });
      }
    });
  });
})();
