var el = document.querySelector('#abt-header-reveal'),
watcher = scrollMonitor.create(el, 0),
abtHeader = new RevealFx(el, {
  revealSettings : {
    bgcolor: '#d6312b',
    direction: 'lr',
    isContentHidden: false,
    delay: 1000,
    duration: 1500,
    onCover: function(contentEl, revealerEl) {
      contentEl.style.opacity = 1;
    }
  }
}),
abtImg = new RevealFx(document.querySelector('#abt-video-reveal'), {
  revealSettings : {
    bgcolor: '#d6312b',
    direction: 'lr',
    duration: 1500,
    delay: 1500,
    isContentHidden: false,
    onCover: function(contentEl, revealerEl) {
      contentEl.style.opacity = 1;
    }
  }
}),
abtBlockHeader = new RevealFx(document.querySelector('#abt-block-reveal'), {
  revealSettings : {
    bgcolor: '#999',
    direction: 'rl',
    duration: 750,
    delay: 2000,
    onCover: function(contentEl, revealerEl) {
      contentEl.style.opacity = 1;
    }
  }
});
watcher.enterViewport(function() {
  abtHeader.reveal();
  abtImg.reveal();
  abtBlockHeader.reveal();
  watcher.destroy();
});

if ($(window).width() >= 770) {
  // Video js
  var player = videojs('abt-video');
  player.muted(true);
  var playAndFullscreen = document.getElementsByClassName('video-block')[0];
  playAndFullscreen.addEventListener('click', function(e) {
    e.preventDefault();
    player.play();
    player.requestFullscreen();
    full = player.isFullscreen(true);
    player.muted(false);
  }, false);
  var onFullScreen = function(){
    if(this.isFullscreen()){
      this.muted(false);
    }
    else{
      this.muted(true);
    }
  };
  player.on("fullscreenchange", onFullScreen);

  $('.w-vid').bind('mousemove', function(e){
    $('.play-text').css({
      left:  e.pageX + 30,
      top:   e.pageY - 7,
      opacity: 1
    });
  });
  $('.w-vid').on('mouseleave', function(e){
    $('.play-text').css({
      opacity: 0
    });
  });
}
else{
  var player = videojs('abt-video');
  player.autoplay(false);
  player.muted(true);
  $('#abt-video').hide();
  $('#videoPop').magnificPopup({
    type:'iframe',
    iframe: {
      markup: '<div class="mfp-iframe-scaler">'+
          '<div class="mfp-close"></div>'+
          '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
          '</div>',
      patterns: {
      youtube: {
        index: 'youtube.com/',
        id: 'v=',
        src: '//www.youtube.com/embed/%id%?autoplay=1'
      }
      },
      srcAction: 'iframe_src'
    }
  });
}
var viewport = document.querySelector('.timeline');
var content = viewport.querySelector('.timeline-base');
let scr = new ScrollBooster({
  viewport: viewport,
  content: content,
  mode: 'x',
  onUpdate: (data)=> {
    content.style.transform = `translate(
      ${-data.position.x}px
    )`
  }
});
$(".timeline").on("mousedown", function () {
    $(this).addClass("mouseDown");
}).on("mouseup", function () {
    $(this).removeClass("mouseDown");
});
