<?php

return [
    'plugin' => [
        'name' => 'Builder',
        'description' => 'Proporciona herramientas visuales para la construcción de plugins de October.',
        'add' => 'Crear plugin',
        'no_records' => 'No se encuentran plugins',
        'no_name' => 'Sin nombre',
        'search' => 'Buscar...',
        'filter_description' => 'Mostrar todos los plugins o sólo tus plugins.',
        'settings' => 'Configuración',
        'entity_name' => 'Plugin',
        'field_name' => 'Nombre',
        'field_author' => 'Autor',
        'field_description' => 'Descripción',
        'field_icon' => 'Icono plugin',
        'field_plugin_namespace' => 'Espacio de nombres de plugin',
        'field_author_namespace' => 'Espacio de nombres de autor',
        'field_namespace_description' => 'Namespace can contain only Latin letters and digits and should start with a Latin letter. Example plugin namespace: Blog',
        'field_author_namespace_description' => 'You cannot change the namespaces with Builder after you create the plugin. Example author namespace: JohnSmith',
        'tab_general' => 'Parametros generales',
        'tab_description' => 'Descripción',
        'field_homepage' => 'Plugin homepage URL',
        'no_description' => 'No hay descripción proporcionada para este plugin',
        'error_settings_not_editable' => 'Configuración de este plugin no se pueden editar con el Builder.',
        'update_hint' => 'Puedes editar el nombre de plugins y descripción localizada en la pestaña de localizaciones.',
        'manage_plugins' => 'Crear y editar plugins',
    ],
    'author_name' => [
        'title' => 'Nombre del autor',
        'description' => 'Por defecto el nombre del autor a utilizar para sus nuevos plugins. El nombre del autor no es fijo - se puede cambiar en la configuración de los plugins en cualquier momento.',
    ],
    'author_namespace' => [
        'title' => 'Espacio de nombres',
        'description' => 'Si desarrolla para el Marketplace, el espacio de nombres debe coincidir con el código de autor y no puede ser cambiado. Consulte la documentación para más detalles.',
    ],
    'database' => [
        'menu_label' => 'Base de datos',
        'no_records' => 'Tablas no encontradas',
        'search' => 'Buscar...',
        'confirmation_delete_multiple' => '¿Eliminar las tablas seleccionadas?',
        'field_name' => 'Nombre de la tabla',
        'tab_columns' => 'Columnas',
        'column_name_name' => 'Columna',
        'column_name_required' => 'Please provide the column name',
        'column_name_type' => 'Tipo',
        'column_type_required' => 'Please select the column type',
        'column_name_length' => 'Length',
        'column_validation_length' => 'The Length value should be integer or specified as precision and scale (10,2) for decimal columns. Spaces are not allowed in the length column.',
        'column_validation_title' => 'Only digits, lower-case Latin letters and underscores are allowed in column names',
        'column_name_unsigned' => 'Unsigned',
        'column_name_nullable' => 'Nullable',
        'column_auto_increment' => 'AUTOINCR',
        'column_default' => 'Default',
        'column_auto_primary_key' => 'PK',
        'tab_new_table' => 'Nueva tabla',
        'btn_add_column' => 'Añadir columna',
        'btn_delete_column' => 'Borrar columna',
        'confirm_delete' => '¿Borrar la tabla?',
        'error_enum_not_supported' => 'The table contains column(s) with type "enum" which is not currently supported by the Builder.',
        'error_table_name_invalid_prefix' => "Table name should start with the plugin prefix: ':prefix'.",
        'error_table_name_invalid_characters' => 'Invalid table name. Table names should contain only Latin letters, digits and underscores. Names should start with a Latin letter and could not contain spaces.',
        'error_table_duplicate_column' => "Duplicate column name: ':column'.",
        'error_table_auto_increment_in_compound_pk' => 'An auto-increment column cannot be a part of a compound primary key.',
        'error_table_mutliple_auto_increment' => 'The table cannot contain multiple auto-increment columns.',
        'error_table_auto_increment_non_integer' => 'Auto-increment columns should have integer type.',
        'error_table_decimal_length' => "The Length parameter for :type type should be in format '10,2', without spaces.",
        'error_table_length' => 'The Length parameter for :type type should be specified as integer.',
        'error_unsigned_type_not_int' => "Error in the ':column' column. The Unsigned flag can be applied only to integer type columns.",
        'error_integer_default_value' => "Invalid default value for the integer column ':column'. The allowed formats are '10', '-10'.",
        'error_decimal_default_value' => "Invalid default value for the decimal or double column ':column'. The allowed formats are '1.00', '-1.00'.",
        'error_boolean_default_value' => "Invalid default value for the boolean column ':column'. The allowed values are '0' and '1'.",
        'error_unsigned_negative_value' => "The default value for the unsigned column ':column' can't be negative.",
        'error_table_already_exists' => "La tabla ':name' ya existe en la base de datos.",
    ],
    'model' => [
        'menu_label' => 'Modelos',
        'entity_name' => 'Modelo',
        'no_records' => 'Modelos no encontrados',
        'search' => 'Buscar...',
        'add' => 'Añadir...',
        'forms' => 'Formularios',
        'lists' => 'Listas',
        'field_class_name' => 'Nombre Clase',
        'field_database_table' => 'Tabla de base de datos',
        'error_class_name_exists' => 'Ya existe el archivo modelo para el nombre de clase especificado: :path',
        'add_form' => 'Añadir formulario',
        'add_list' => 'Añadir lista',
    ],
    'form' => [
        'saved' => 'Formulario salvado',
        'confirm_delete' => '¿Borrar el formulario?',
        'tab_new_form' => 'Nuevo formulario',
        'property_label_title' => 'Etiqueta',
        'property_label_required' => 'Please specify the control label.',
        'property_span_title' => 'Span',
        'property_comment_title' => 'Commentario',
        'property_comment_above_title' => 'Comment above',
        'property_default_title' => 'Default',
        'property_checked_default_title' => 'Checked by default',
        'property_css_class_title' => 'CSS class',
        'property_css_class_description' => 'Optional CSS class to assign to the field container.',
        'property_disabled_title' => 'Disabled',
        'property_hidden_title' => 'Hidden',
        'property_required_title' => 'Required',
        'property_field_name_title' => 'Field name',
        'property_placeholder_title' => 'Placeholder',
        'property_default_from_title' => 'Default from',
        'property_stretch_title' => 'Stretch',
        'property_stretch_description' => 'Specifies if this field stretches to fit the parent height.',
        'property_context_title' => 'Context',
        'property_context_description' => 'Specifies what form context should be used when displaying the field.',
        'property_context_create' => 'Create',
        'property_context_update' => 'Update',
        'property_context_preview' => 'Preview',
        'property_dependson_title' => 'Depends on',
        'property_trigger_action' => 'Action',
        'property_trigger_show' => 'Show',
        'property_trigger_hide' => 'Hide',
        'property_trigger_enable' => 'Enable',
        'property_trigger_disable' => 'Disable',
        'property_trigger_empty' => 'Empty',
        'property_trigger_field' => 'Field',
        'property_trigger_field_description' => 'Defines the other field name that will trigger the action.',
        'property_trigger_condition' => 'Condition',
        'property_trigger_condition_description' => 'Determines the condition the specified field should satisfy for the condition to be considered "true". Supported values: checked, unchecked, value[somevalue].',
        'property_trigger_condition_checked' => 'Checked',
        'property_trigger_condition_unchecked' => 'Unchecked',
        'property_trigger_condition_somevalue' => 'value[enter-the-value-here]',
        'property_preset_title' => 'Preset',
        'property_preset_description' => 'Allows the field value to be initially set by the value of another field, converted using the input preset converter.',
        'property_preset_field' => 'Field',
        'property_preset_field_description' => 'Defines the other field name to source the value from.',
        'property_preset_type' => 'Type',
        'property_preset_type_description' => 'Specifies the conversion type',
        'property_attributes_title' => 'Attributes',
        'property_attributes_description' => 'Custom HTML attributes to add to the form field element.',
        'property_container_attributes_title' => 'Container attributes',
        'property_container_attributes_description' => 'Custom HTML attributes to add to the form field container element.',
        'property_group_advanced' => 'Advanced',
        'property_dependson_description' => 'A list of other field names this field depends on, when the other fields are modified, this field will update. One field per line.',
        'property_trigger_title' => 'Trigger',
        'property_trigger_description' => 'Allows to change elements attributes such as visibility or value, based on another elements\' state.',
        'property_default_from_description' => 'Takes the default value from the value of another field.',
        'property_field_name_required' => 'The field name is required',
        'property_field_name_regex' => 'The field name can contain only Latin letters, digits, underscores, dashes and square brackets.',
        'property_attributes_size' => 'Size',
        'property_attributes_size_tiny' => 'Tiny',
        'property_attributes_size_small' => 'Small',
        'property_attributes_size_large' => 'Large',
        'property_attributes_size_huge' => 'Huge',
        'property_attributes_size_giant' => 'Giant',
        'property_comment_position' => 'Comment position',
        'property_comment_position_above' => 'Above',
        'property_comment_position_below' => 'Below',
        'property_hint_path' => 'Hint partial path',
        'property_hint_path_description' => 'Path to a partial file that contains the hint text. Use the $ symbol to refer the plugins root directory, for example: $/acme/blog/partials/_hint.htm',
        'property_hint_path_required' => 'Please enter the hint partial path',
        'property_partial_path' => 'Partial path',
        'property_partial_path_description' => 'Path to a partial file. Use the $ symbol to refer the plugins root directory, for example: $/acme/blog/partials/_partial.htm',
        'property_partial_path_required' => 'Please enter the partial path',
        'property_code_language' => 'Language',
        'property_code_theme' => 'Theme',
        'property_theme_use_default' => 'Use default theme',
        'property_group_code_editor' => 'Code editor',
        'property_gutter' => 'Gutter',
        'property_gutter_show' => 'Visible',
        'property_gutter_hide' => 'Hidden',
        'property_wordwrap' => 'Word wrap',
        'property_wordwrap_wrap' => 'Wrap',
        'property_wordwrap_nowrap' => 'Don\'t wrap',
        'property_fontsize' => 'Font size',
        'property_codefolding' => 'Code folding',
        'property_codefolding_manual' => 'Manual',
        'property_codefolding_markbegin' => 'Mark begin',
        'property_codefolding_markbeginend' => 'Mark begin and end',
        'property_autoclosing' => 'Auto closing',
        'property_enabled' => 'Enabled',
        'property_disabled' => 'Disabled',
        'property_soft_tabs' => 'Soft tabs',
        'property_tab_size' => 'Tab size',
        'property_readonly' => 'Read only',
        'property_use_default' => 'Use default settings',
        'property_options' => 'Opciones',
        'property_prompt' => 'Prompt',
        'property_prompt_description' => 'Text to display for the create button.',
        'property_prompt_default' => 'Add new item',
        'property_available_colors' => 'Available colors',
        'property_available_colors_description' => 'List of available colors in hex format (#FF0000). Leave empty for the default color set. Enter one value per line.',
        'property_datepicker_mode' => 'Mode',
        'property_datepicker_mode_date' => 'Date',
        'property_datepicker_mode_datetime' => 'Date and time',
        'property_datepicker_mode_time' => 'Time',
        'property_datepicker_min_date' => 'Min date',
        'property_datepicker_min_date_description' => 'The minimum/earliest date that can be selected. Leave empty for the default value (2000-01-01).',
        'property_datepicker_max_date' => 'Max date',
        'property_datepicker_max_date_description' => 'The maximum/latest date that can be selected. Leave empty for the default value (2020-12-31).',
        'property_datepicker_date_invalid_format' => 'Invalid date format. Use format YYYY-MM-DD.',
        'property_markdown_mode' => 'Mode',
        'property_markdown_mode_split' => 'Split',
        'property_markdown_mode_tab' => 'Tab',
        'property_fileupload_mode' => 'Mode',
        'property_fileupload_mode_file' => 'File',
        'property_fileupload_mode_image' => 'Imagen',
        'property_group_fileupload' => 'File upload',
        'property_fileupload_prompt' => 'Prompt',
        'property_fileupload_prompt_description' => 'Text to display for the upload button, applies to File mode only, optional.',
        'property_fileupload_image_width' => 'Image width',
        'property_fileupload_image_width_description' => 'Optional parameter - images will be resized to this width. Applies to Image mode only.',
        'property_fileupload_invalid_dimension' => 'Invalid dimension value - please enter a number.',
        'property_fileupload_image_height' => 'Image height',
        'property_fileupload_image_height_description' => 'Optional parameter - images will be resized to this height. Applies to Image mode only.',
        'property_fileupload_file_types' => 'File types',
        'property_fileupload_file_types_description' => 'Optional comma separated list of file extensions that are accepted by the uploader. Eg: zip,txt',
        'property_fileupload_mime_types' => 'MIME types',
        'property_fileupload_mime_types_description' => 'Optional comma separated list of MIME types that are accepted by the uploader, either as file extensions or fully qualified names. Eg: bin,txt',
        'property_fileupload_use_caption' => 'Use caption',
        'property_fileupload_use_caption_description' => 'Allows a title and description to be set for the file.',
        'property_fileupload_thumb_options' => 'Thumbnail options',
        'property_fileupload_thumb_options_description' => 'Manages options for the automatically generated thumbnails. Applies only for the Image mode.',
        'property_fileupload_thumb_mode' => 'Mode',
        'property_fileupload_thumb_auto' => 'Auto',
        'property_fileupload_thumb_exact' => 'Exact',
        'property_fileupload_thumb_portrait' => 'Portrait',
        'property_fileupload_thumb_landscape' => 'Landscape',
        'property_fileupload_thumb_crop' => 'Crop',
        'property_fileupload_thumb_extension' => 'File extension',
        'property_name_from' => 'Name column',
        'property_name_from_description' => 'Relation column name to use for displaying a name.',
        'property_relation_select' => 'Select',
        'property_relation_select_description' => 'CONCAT multiple columns together for displaying a name',
        'property_description_from' => 'Description column',
        'property_description_from_description' => 'Relation column name to use for displaying a description.',
        'property_recordfinder_prompt' => 'Prompt',
        'property_recordfinder_prompt_description' => 'Text to display when there is no record selected. The %s character represents the search icon. Leave empty for the default prompt.',
        'property_recordfinder_list' => 'List configuration',
        'property_recordfinder_list_description' => 'A reference to a list column definition file. Use the $ symbol to refer the plugins root directory, for example: $/acme/blog/lists/_list.yaml',
        'property_recordfinder_list_required' => 'Please provide a path to the list YAML file',
        'property_group_recordfinder' => 'Record finder',
        'property_mediafinder_mode' => 'Mode',
        'property_mediafinder_mode_file' => 'File',
        'property_mediafinder_mode_image' => 'Image',
        'property_mediafinder_prompt' => 'Prompt',
        'property_mediafinder_prompt_description' => 'Text to display when there is no item selected. The %s character represents the media manager icon. Leave empty for the default prompt.',
        'property_group_relation' => 'Relation',
        'property_relation_prompt' => 'Prompt',
        'property_relation_prompt_description' => 'Text to display when there is no available selections.',
        'control_group_standard' => 'Standard',
        'control_group_widgets' => 'Widgets',
        'click_to_add_control' => 'Add control',
        'loading' => 'Cargando...',
        'control_text' => 'Texto',
        'control_text_description' => 'Single line text box',
        'control_password' => 'Contraseña',
        'control_password_description' => 'Single line password text field',
        'control_checkbox' => 'Checkbox',
        'control_checkbox_description' => 'Single checkbox',
        'control_switch' => 'Switch',
        'control_switch_description' => 'Single switchbox, an alternative for checkbox',
        'control_textarea' => 'Text area',
        'control_textarea_description' => 'Multiline text box with controllable height',
        'control_dropdown' => 'Dropdown',
        'control_dropdown_description' => 'Dropdown list with static or dynamic options',
        'control_unknown' => 'Unknown control type: :type',
        'control_repeater' => 'Repeater',
        'control_repeater_description' => 'Outputs a repeating set of form controls',
        'control_number' => 'Number',
        'control_number_description' => 'Single line text box that takes numbers only',
        'control_hint' => 'Hint',
        'control_hint_description' => 'Outputs a partial contents in a box that can be hidden by the user',
        'control_partial' => 'Partial',
        'control_partial_description' => 'Outputs a partial contents',
        'control_section' => 'Section',
        'control_section_description' => 'Displays a form section with heading and subheading',
        'control_radio' => 'Radio list',
        'control_radio_description' => 'A list of radio options, where only one item can be selected at a time',
        'control_radio_option_1' => 'Option 1',
        'control_radio_option_2' => 'Option 2',
        'control_checkboxlist' => 'Checkbox list',
        'control_checkboxlist_description' => 'A list of checkboxes, where multiple items can be selected',
        'control_codeeditor' => 'Code editor',
        'control_codeeditor_description' => 'Plaintext editor for formatted code or markup',
        'control_colorpicker' => 'Color picker',
        'control_colorpicker_description' => 'A field for selecting a hexadecimal color value',
        'control_datepicker' => 'Date picker',
        'control_datepicker_description' => 'Text field used for selecting date and times',
        'control_richeditor' => 'Rich editor',
        'control_richeditor_description' => 'Visual editor for rich formatted text, also known as a WYSIWYG editor',
        'control_markdown' => 'Markdown editor',
        'control_markdown_description' => 'Basic editor for Markdown formatted text',
        'control_fileupload' => 'File upload',
        'control_fileupload_description' => 'File uploader for images or regular files',
        'control_recordfinder' => 'Record finder',
        'control_recordfinder_description' => 'Field with details of a related record with the record search feature',
        'control_mediafinder' => 'Media finder',
        'control_mediafinder_description' => 'Field for selecting an item from the Media Manager library',
        'control_relation' => 'Relation',
        'control_relation_description' => 'Displays either a dropdown or checkbox list for selecting a related record',
        'error_file_name_required' => 'Please enter the form file name.',
        'error_file_name_invalid' => 'The file name can contain only Latin letters, digits, underscores, dots and hashes.',
        'span_left' => 'Left',
        'span_right' => 'Right',
        'span_full' => 'Full',
        'span_auto' => 'Auto',
        'empty_tab' => 'Empty tab',
        'confirm_close_tab' => 'The tab contains controls which will be deleted. Continue?',
        'tab' => 'Form tab',
        'tab_title' => 'Title',
        'controls' => 'Controls',
        'property_tab_title_required' => 'The tab title is required.',
        'tabs_primary' => 'Primary tabs',
        'tabs_secondary' => 'Secondary tabs',
        'tab_stretch' => 'Stretch',
        'tab_stretch_description' => 'Specifies if this tabs container stretches to fit the parent height.',
        'tab_css_class' => 'CSS class',
        'tab_css_class_description' => 'Assigns a CSS class to the tabs container.',
        'tab_name_template' => 'Tab %s',
        'tab_already_exists' => 'Tab with the specified title already exists.',
    ],
    'list' => [
        'tab_new_list' => 'Nueva lista',
        'saved' => 'Lista guardada',
        'confirm_delete' => '¿Borrar la lista?',
        'tab_columns' => 'Columnas',
        'btn_add_column' => 'Añadir columna',
        'btn_delete_column' => 'Borrar columna',
        'column_dbfield_label' => 'Campo',
        'column_dbfield_required' => 'Por favor proporcione el campo del modelo',
        'column_name_label' => 'Etiqueta',
        'column_label_required' => 'Por favor proporcione la etiqueta de columna',
        'column_type_label' => 'Tipo',
        'column_type_required' => 'Por favor indique el tipo de columna',
        'column_type_text' => 'Texto',
        'column_type_number' => 'Numero',
        'column_type_switch' => 'Switch',
        'column_type_datetime' => 'Datetime',
        'column_type_date' => 'Fecha',
        'column_type_time' => 'Hora',
        'column_type_timesince' => 'Tine since',
        'column_type_timetense' => 'Tine tense',
        'column_type_select' => 'Select',
        'column_type_partial' => 'Partial',
        'column_label_default' => 'Default',
        'column_label_searchable' => 'Buscable',
        'column_label_sortable' => 'Ordenable',
        'column_label_invisible' => 'Invisible',
        'column_label_select' => 'Select',
        'column_label_relation' => 'Relation',
        'column_label_css_class' => 'CSS class',
        'column_label_width' => 'Width',
        'column_label_path' => 'Path',
        'column_label_format' => 'Format',
        'column_label_value_from' => 'Value from',
        'error_duplicate_column' => "Duplicate column field name: ':column'.",
    ],
    'controller' => [
        'menu_label' => 'Controladores',
        'no_records' => 'No se encuentran controladores del plugin',
        'controller' => 'Controlador',
        'behaviors' => 'Comportamientos',
        'new_controller' => 'Nuevo controlador',
        'error_controller_has_no_behaviors' => 'The controller doesn\'t have configurable behaviors.',
        'error_invalid_yaml_configuration' => 'Error loading behavior configuration file: :file',
        'behavior_form_controller' => 'Form controller behavior',
        'behavior_form_controller_description' => 'Adds form functionality to a back-end page. The behavior provides three pages called Create, Update and Preview.',
        'property_behavior_form_placeholder' => '--select form--',
        'property_behavior_form_name' => 'Nombre',
        'property_behavior_form_name_description' => 'The name of the object being managed by this form',
        'property_behavior_form_name_required' => 'Please enter the form name',
        'property_behavior_form_file' => 'Form configuration',
        'property_behavior_form_file_description' => 'Reference to a form field definition file',
        'property_behavior_form_file_required' => 'Please enter a path to the form configuration file',
        'property_behavior_form_model_class' => 'Model class',
        'property_behavior_form_model_class_description' => 'A model class name, the form data is loaded and saved against this model.',
        'property_behavior_form_model_class_required' => 'Please select a model class',
        'property_behavior_form_default_redirect' => 'Default redirect',
        'property_behavior_form_default_redirect_description' => 'A page to redirect to by default when the form is saved or cancelled.',
        'property_behavior_form_create' => 'Create record page',
        'property_behavior_form_redirect' => 'Redirect',
        'property_behavior_form_redirect_description' => 'A page to redirect to when a record is created.',
        'property_behavior_form_redirect_close' => 'Close redirect',
        'property_behavior_form_redirect_close_description' => 'A page to redirect to when a record is created and the close post variable is sent with the request.',
        'property_behavior_form_flash_save' => 'Save flash message',
        'property_behavior_form_flash_save_description' => 'Flash message to display when record is saved.',
        'property_behavior_form_page_title' => 'Page title',
        'property_behavior_form_update' => 'Update record page',
        'property_behavior_form_update_redirect' => 'Redirect',
        'property_behavior_form_create_redirect_description' => 'A page to redirect to when a record is saved.',
        'property_behavior_form_flash_delete' => 'Delete flash message',
        'property_behavior_form_flash_delete_description' => 'Flash message to display when record is deleted.',
        'property_behavior_form_preview' => 'Preview record page',
        'behavior_list_controller' => 'List controller behavior',
        'behavior_list_controller_description' => 'Provides the sortable and searchable list with optional links on its records. The behavior automatically creates the controller action "index".',
        'property_behavior_list_title' => 'List title',
        'property_behavior_list_title_required' => 'Please enter the list title',
        'property_behavior_list_placeholder' => '--select list--',
        'property_behavior_list_model_class' => 'Model class',
        'property_behavior_list_model_class_description' => 'A model class name, the list data is loaded from this model.',
        'property_behavior_form_model_class_placeholder' => '--select model--',
        'property_behavior_list_model_class_required' => 'Please select a model class',
        'property_behavior_list_model_placeholder' => '--select model--',
        'property_behavior_list_file' => 'List configuration file',
        'property_behavior_list_file_description' => 'Reference to a list definition file',
        'property_behavior_list_file_required' => 'Please enter a path to the list configuration file',
        'property_behavior_list_record_url' => 'Record URL',
        'property_behavior_list_record_url_description' => 'Link each list record to another page. Eg: users/update:id. The :id part is replaced with the record identifier.',
        'property_behavior_list_no_records_message' => 'No records message',
        'property_behavior_list_no_records_message_description' => 'A message to display when no records are found',
        'property_behavior_list_recs_per_page' => 'Records per page',
        'property_behavior_list_recs_per_page_description' => 'Records to display per page, use 0 for no pages. Default: 0',
        'property_behavior_list_recs_per_page_regex' => 'Records per page should be an integer value',
        'property_behavior_list_show_setup' => 'Show setup button',
        'property_behavior_list_show_sorting' => 'Show sorting',
        'property_behavior_list_default_sort' => 'Default sorting',
        'property_behavior_form_ds_column' => 'Columna',
        'property_behavior_form_ds_direction' => 'Direction',
        'property_behavior_form_ds_asc' => 'Ascending',
        'property_behavior_form_ds_desc' => 'Descending',
        'property_behavior_list_show_checkboxes' => 'Show checkboxes',
        'property_behavior_list_onclick' => 'On click handler',
        'property_behavior_list_onclick_description' => 'Custom JavaScript code to execute when clicking on a record.',
        'property_behavior_list_show_tree' => 'Show tree',
        'property_behavior_list_show_tree_description' => 'Displays a tree hierarchy for parent/child records.',
        'property_behavior_list_tree_expanded' => 'Tree expanded',
        'property_behavior_list_tree_expanded_description' => 'Determines if tree nodes should be expanded by default.',
        'property_behavior_list_toolbar' => 'Toolbar',
        'property_behavior_list_toolbar_buttons' => 'Buttons partial',
        'property_behavior_list_toolbar_buttons_description' => 'Reference to a controller partial file with the toolbar buttons. Eg: list_toolbar',
        'property_behavior_list_search' => 'Buscar',
        'property_behavior_list_search_prompt' => 'Search prompt',
        'property_behavior_list_filter' => 'Filter configuration',
        'behavior_reorder_controller' => 'Reorder controller behavior',
        'behavior_reorder_controller_description' => 'Provides features for sorting and reordering on its records. The behavior automatically creates the controller action "reorder".',
        'property_behavior_reorder_title' => 'Reorder title',
        'property_behavior_reorder_title_required' => 'Please enter the reorder title',
        'property_behavior_reorder_name_from' => 'Attribute name',
        'property_behavior_reorder_name_from_description' => 'Model\'s attribute that should be used as a label for each record.',
        'property_behavior_reorder_name_from_required' => 'Please enter the attribute name',
        'property_behavior_reorder_model_class' => 'Model class',
        'property_behavior_reorder_model_class_description' => 'A model class name, the reorder data is loaded from this model.',
        'property_behavior_reorder_model_class_placeholder' => '--select model--',
        'property_behavior_reorder_model_class_required' => 'Please select a model class',
        'property_behavior_reorder_model_placeholder' => '--select model--',
        'property_behavior_reorder_toolbar' => 'Toolbar',
        'property_behavior_reorder_toolbar_buttons' => 'Buttons partial',
        'property_behavior_reorder_toolbar_buttons_description' => 'Reference to a controller partial file with the toolbar buttons. Eg: reorder_toolbar',
        'error_controller_not_found' => 'Original controller file is not found.',
        'error_invalid_config_file_name' => 'The behavior :class configuration file name (:file) contains invalid characters and cannot be loaded.',
        'error_file_not_yaml' => 'The behavior :class configuration file (:file) is not a YAML file. Only YAML configuration files are supported.',
        'saved' => 'Controller saved',
        'controller_name' => 'Controller name',
        'controller_name_description' => 'Controller name defines the class name and URL of the controller\'s back-end pages. Standard PHP variable naming conventions apply. The first symbol should be a capital Latin letter. Examples: Categories, Posts, Products.',
        'base_model_class' => 'Base model class',
        'base_model_class_description' => 'Select a model class to use as a base model in behaviors that require or support models. You can configure the behaviors later.',
        'base_model_class_placeholder' => '--select model--',
        'controller_behaviors' => 'Behaviors',
        'controller_behaviors_description' => 'Select behaviors the controller should implement. Builder will create view files required for the behaviors automatically.',
        'controller_permissions' => 'Permisos',
        'controller_permissions_description' => 'Select user permissions that can access the controller views. Permissions can be defined on the Permissions tab of the Builder. You can change this option in the controller PHP script later.',
        'controller_permissions_no_permissions' => 'The plugin doesn\'t define any permissions.',
        'menu_item' => 'Active menu item',
        'menu_item_description' => 'Select a menu item to make active for the controller pages. You can change this option in the controller PHP script later.',
        'menu_item_placeholder' => '--select menu item--',
        'error_unknown_behavior' => 'The behavior class :class is not registered in the behavior library.',
        'error_behavior_view_conflict' => 'The selected behaviors provide conflicting views (:view) and cannot be used together in a controller.',
        'error_behavior_config_conflict' => 'The selected behaviors provide conflicting configuration files (:file) and cannot be used together in a controller.',
        'error_behavior_view_file_not_found' => 'View template :view of the behavior :class cannot be found.',
        'error_behavior_config_file_not_found' => 'Configuration template :file of the behavior :class cannot be found.',
        'error_controller_exists' => 'Controller file already exists: :file.',
        'error_controller_name_invalid' => 'Invalid controller name format. The name can only contain digits and Latin letters. The first symbol should be a capital Latin letter.',
        'error_behavior_view_file_exists' => 'Controller view file already exists: :view.',
        'error_behavior_config_file_exists' => 'Behavior configuration file already exists: :file.',
        'error_save_file' => 'Error saving controller file: :file',
        'error_behavior_requires_base_model' => 'Behavior :behavior requires a base model class to be selected.',
        'error_model_doesnt_have_lists' => 'The selected model doesn\'t have any lists. Please create a list first.',
        'error_model_doesnt_have_forms' => 'The selected model doesn\'t have any forms. Please create a form first.',
    ],
    'version' => [
        'menu_label' => 'Versiones',
        'no_records' => 'Versiones del plugin no encontradas',
        'search' => 'Buscar...',
        'tab' => 'Versiones',
        'saved' => 'Versión salvada',
        'confirm_delete' => '¿Borrar esta versión?',
        'tab_new_version' => 'Nueva versión',
        'migration' => 'Migración',
        'seeder' => 'Seeder',
        'custom' => 'Increase the verison number',
        'apply_version' => 'Apply version',
        'applying' => 'Applying...',
        'rollback_version' => 'Rollback versión',
        'rolling_back' => 'Rolling back...',
        'applied' => 'Version applied',
        'rolled_back' => 'Version rolled back',
        'hint_save_unapplied' => 'You saved an unapplied version. Unapplied versions could be automatically applied when you or another user logs into the back-end or when a database table is saved in the Database section of the Builder.',
        'hint_rollback' => 'Rolling back a version will also roll back all versions newer than this version. Please note that unapplied versions could be automatically applied by the system when you or another user logs into the back-end or when a database table is saved in the Database section of the Builder.',
        'hint_apply' => 'Applying a version will also apply all older unapplied versions of the plugin.',
        'dont_show_again' => 'Don\'t show again',
        'save_unapplied_version' => 'Save unapplied version',
    ],
    'menu' => [
        'menu_label' => 'Backend Menu',
        'tab' => 'Menus',
        'items' => 'Menu items',
        'saved' => 'Menus saved',
        'add_main_menu_item' => 'Add main menu item',
        'new_menu_item' => 'Menu Item',
        'add_side_menu_item' => 'Add sub-item',
        'side_menu_item' => 'Side menu item',
        'property_label' => 'Etiqueta',
        'property_label_required' => 'Please enter the menu item labels.',
        'property_url_required' => 'Please enter the menu item URL',
        'property_url' => 'URL',
        'property_icon' => 'Icono',
        'property_icon_required' => 'Please select an icon',
        'property_permissions' => 'Permissions',
        'property_order' => 'Order',
        'property_order_invalid' => 'Please enter the menu item order as integer value.',
        'property_order_description' => 'Menu item order manages its position in the menu. If the order is not provided, the item will be placed to the end of the menu. The default order values have the increment of 100.',
        'property_attributes' => 'HTML attributes',
        'property_code' => 'Code',
        'property_code_invalid' => 'The code should contain only Latin letter and digits',
        'property_code_required' => 'Please enter the menu item code.',
        'error_duplicate_main_menu_code' => "Duplicate main menu item code: ':code'.",
        'error_duplicate_side_menu_code' => "Duplicate side menu item code: ':code'.",
    ],
    'localization' => [
        'menu_label' => 'Localización',
        'language' => 'Lenguaje',
        'strings' => 'Cadenas',
        'confirm_delete' => '¿Borrar el lenguaje?',
        'tab_new_language' => 'Nuevo lenguaje',
        'no_records' => 'Lenguajes no encontrados',
        'saved' => 'Archivo de lenguaje guardado',
        'error_cant_load_file' => 'Cannot load the requested language file - file not found.',
        'error_bad_localization_file_contents' => 'Cannot load the requested language file. Language files can only contain array definitions and strings.',
        'error_file_not_array' => 'Cannot load the requested language file. Language files should return an array.',
        'save_error' => "Error saving file ':name'. Please check write permissions.",
        'error_delete_file' => 'Error deleting localization file.',
        'add_missing_strings' => 'Añadir cadenas que faltan',
        'copy' => 'Copiar',
        'add_missing_strings_label' => 'Select language to copy missing strings from',
        'no_languages_to_copy_from' => 'There are no other languages to copy strings from.',
        'new_string_warning' => 'Nueva cadena o sección',
        'structure_mismatch' => 'The structure of the source language file doesn\'t match the structure of the file being edited. Some individual strings in the edited file correspond to sections in the source file (or vice versa) and cannot be merged automatically.',
        'create_string' => 'Create new string',
        'string_key_label' => 'String key',
        'string_key_comment' => 'Enter the string key using period as a section separator. For example: plugin.search. The string will be created in the plugin\'s default language localization file.',
        'string_value' => 'String value',
        'string_key_is_empty' => 'String key should not be empty',
        'string_value_is_empty' => 'String value should not be empty',
        'string_key_exists' => 'The string key already exists',
    ],
    'permission' => [
        'menu_label' => 'Permisos',
        'tab' => 'Permisos',
        'form_tab_permissions' => 'Permisos',
        'btn_add_permission' => 'Añadir permisos',
        'btn_delete_permission' => 'Borrar permisos',
        'column_permission_label' => 'Permission code',
        'column_permission_required' => 'Please enter the permission code',
        'column_tab_label' => 'Titulo pestaña',
        'column_tab_required' => 'Por favor introduzca el permiso de el título de la pestaña',
        'column_label_label' => 'Etiqueta',
        'column_label_required' => 'Por favor introduzca permiso de etiqueta',
        'saved' => 'Permisos guardados',
        'error_duplicate_code' => "Duplicate permission code: ':code'.",
    ],
    'yaml' => [
        'save_error' => "Error al guardar el archivo ':name'. Consulte permisos de escritura.",
    ],
    'common' => [
        'error_file_exists' => "El archivo ya existe: ':path'.",
        'field_icon_description' => 'October usa Font Autumn icons: http://octobercms.com/docs/ui/icon',
        'destination_dir_not_exists' => "El directorio de destino no existe: ':path'.",
        'error_make_dir' => "Error al crear directorio: ':name'.",
        'error_dir_exists' => "El directorio ya existe!: ':path'.",
        'template_not_found' => "Archivo de plantilla no encuentrado: ':name'.",
        'error_generating_file' => "Error al generar el archivo: ':path'.",
        'error_loading_template' => "Error al cargar el archivo plantilla: ':name'.",
        'select_plugin_first' => 'Seleccione primero un plugin. Para ver la lista de plugin, haga clic en el icono > en la barra lateral izquierda.',
        'plugin_not_selected' => 'Plugin no seleccionado',
        'add' => 'Añadir',
    ],
    'migration' => [
        'entity_name' => 'Migración',
        'error_version_invalid' => 'The version should be specified in format 1.0.1',
        'field_version' => 'Versión',
        'field_description' => 'Descripción',
        'field_code' => 'Code',
        'save_and_apply' => 'Salvar y Aplicar',
        'error_version_exists' => 'The migration version already exists.',
        'error_script_filename_invalid' => 'The migration script file name can contain only Latin letters, digits and underscores. The name should start with a Latin letter and could not contain spaces.',
        'error_cannot_change_version_number' => 'Cannot change version number for an applied version.',
        'error_file_must_define_class' => 'Migration code should define a migration or seeder class. Leave the code field blank if you only want to update the version number.',
        'error_file_must_define_namespace' => 'Migration code should define a namespace. Leave the code field blank if you only want to update the version number.',
        'no_changes_to_save' => 'No hay cambios que salvar.',
        'error_namespace_mismatch' => "The migration code should use the plugin namespace: :namespace",
        'error_migration_file_exists' => "Migration file :file already exists. Please use another class name.",
        'error_cant_delete_applied' => 'This version has already been applied and cannot be deleted. Please rollback the version first.',
    ],
    'components' => [
        'list_title' => 'Record list',
        'list_description' => 'Displays a list of records for a selected model',
        'list_page_number' => 'Page number',
        'list_page_number_description' => 'This value is used to determine what page the user is on.',
        'list_records_per_page' => 'Records per page',
        'list_records_per_page_description' => 'Number of records to display on a single page. Leave empty to disable pagination.',
        'list_records_per_page_validation' => 'Invalid format of the records per page value. The value should be a number.',
        'list_no_records' => 'No records message',
        'list_no_records_description' => 'Message to display in the list in case if there are no records. Used in the default component\'s partial.',
        'list_no_records_default' => 'No records found',
        'list_sort_column' => 'Sort by column',
        'list_sort_column_description' => 'Model column the records should be ordered by',
        'list_sort_direction' => 'Direction',
        'list_display_column' => 'Display column',
        'list_display_column_description' => 'Column to display in the list. Used in the default component\'s partial.',
        'list_display_column_required' => 'Please select a display column.',
        'list_details_page' => 'Details page',
        'list_details_page_description' => 'Page to display record details.',
        'list_details_page_no' => '--no details page--',
        'list_sorting' => 'Sorting',
        'list_pagination' => 'Paginación',
        'list_order_direction_asc' => 'Ascending',
        'list_order_direction_desc' => 'Descending',
        'list_model' => 'Model class',
        'list_scope' => 'Scope',
        'list_scope_description' => 'Optional model scope to fetch the records',
        'list_scope_default' => '--select a scope, optional--',
        'list_details_page_link' => 'Link to the details page',
        'list_details_key_column' => 'Details key column',
        'list_details_key_column_description' => 'Model column to use as a record identifier in the details page links.',
        'list_details_url_parameter' => 'URL parameter name',
        'list_details_url_parameter_description' => 'Name of the details page URL parameter which takes the record identifier.',
        'details_title' => 'Record details',
        'details_description' => 'Displays record details for a selected model',
        'details_model' => 'Model class',
        'details_identifier_value' => 'Identifier value',
        'details_identifier_value_description' => 'Identifier value to load the record from the database. Specify a fixed value or URL parameter name.',
        'details_identifier_value_required' => 'The identifier value is required',
        'details_key_column' => 'Key column',
        'details_key_column_description' => 'Model column to use as a record identifier for fetching the record from the database.',
        'details_key_column_required' => 'The key column name is required',
        'details_display_column' => 'Display column',
        'details_display_column_description' => 'Model column to display on the details page. Used in the default component\'s partial.',
        'details_display_column_required' => 'Please select a display column.',
        'details_not_found_message' => 'Not found message',
        'details_not_found_message_description' => 'Message to display if the record is not found. Used in the default component\'s partial.',
        'details_not_found_message_default' => 'Record not found',
    ],
];
