<?php namespace Linus\Services\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusServices extends Migration
{
    public function up()
    {
        Schema::create('linus_services_', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('content', 1000)->nullable();
            $table->string('slug', 255);
            $table->integer('order_id');
            $table->integer('category')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_services_');
    }
}
