<?php namespace Linus\Services\Models;

use Model;

/**
 * Model
 */
class Service extends Model
{
    use \October\Rain\Database\Traits\Validation;

    use \October\Rain\Database\Traits\SoftDelete;

    use \October\Rain\Database\Traits\Sortable;

    const SORT_ORDER = 'order_id';

    protected $dates = ['deleted_at'];


    /**
     * @var string The database table used by the model.
     */
    public $table = 'linus_services_';

    /**
     * @var array Validation rules
     */
    public $rules = [
      'name' => 'required',
      'slug' => 'required',
      'content' => 'required'
    ];

    public $attachMany = [
        'serv_images' => 'System\Models\File'
    ];
    public $attachOne = [
        'serv_icon' => 'System\Models\File'
    ];

    // public $belongsToMany = [
    //     'cat' => [
    //         'Linus\Services\Models\Category',
    //         'table' => 'linus_services_category_service',
    //         'order' => 'name'
    //     ]
    // ];
    public $hasMany = [
        'projects' => ['Linus\Project\Models\Project']
    ];

}
