<?php namespace Linus\Project\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusProject extends Migration
{
    public function up()
    {
        Schema::create('linus_project_', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('description', 500)->nullable();
            $table->integer('service_id');
            $table->string('location', 255);
            $table->date('start_date');
            $table->date('end_date');
            $table->string('slug', 255);
            $table->integer('order_id');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_project_');
    }
}
