<?php namespace Linus\Project\Models;

use Model;

/**
 * Model
 */
class Project extends Model
{
    use \October\Rain\Database\Traits\Validation;

    use \October\Rain\Database\Traits\SoftDelete;

    use \October\Rain\Database\Traits\Sortable;

    const SORT_ORDER = 'order_id';

    protected $dates = ['deleted_at'];


    /**
     * @var string The database table used by the model.
     */
    public $table = 'linus_project_';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    public $attachMany = [
        'proj_images' => 'System\Models\File'
    ];

    public $belongsTo = [
        'service' => ['Linus\Services\Models\Service']
    ];

    public function scopeListFrontEnd($query, $options = []){
      extract(array_merge([
          'page' => '1',
          'perPage' => '9',
          'service_id' => null,
          'year' => null
      ], $options));
      if($service_id){
          $query->where('service_id', '=', $service_id);
      }
      if($year){
          $query->whereRaw('YEAR(end_date) = '.$year);
      }

      $query->orderBy('name', 'asc');

      // $lastPage = $query->paginate($perPage, $page)->lastPage();
      // if($lastPage < $page){
      //     $page = 1;
      // }
      return $query->paginate('', '');
    }
}
