<?php namespace Linus\Partners\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusPartners extends Migration
{
    public function up()
    {
        Schema::create('linus_partners_', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('type', 255)->nullable();
            $table->string('content', 2000)->nullable();
            $table->string('link', 255)->nullable();
            $table->string('slug', 255);
            $table->integer('order_id');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_partners_');
    }
}
