<?php namespace Linus\Partners;

use System\Classes\PluginBase;
use Yaml;
class Plugin extends PluginBase
{
    public function registerComponents()
    {
    }

    public function registerSettings()
    {
    }

    public function boot(){
      \Event::listen('backend.form.extendFieldsBefore', function (\Backend\Widgets\Form $form) {
        if (
            !$form->getController() instanceof \RainLab\Pages\Controllers\Index ||
            !$form->model instanceof \RainLab\Pages\Classes\Page ||
            $form->isNested
        ) {
            return;
        }
        if ($form->model->viewBag['layout'] == 'homepage') {
          $fields = Yaml::parseFile(themes_path('linus/meta/nested-repeaters.yaml'));
          $videoTitle = Yaml::parseFile(themes_path('linus/meta/video-title.yaml'));
          $form->secondaryTabs['fields']['viewBag[videoLink]'] = [
              'tab'      => 'Hero',
              'type'     => 'text',
              'label'    => 'Video Link',
              'cssClass' => 'secondary-tab ',
              'span'     => 'left'
          ];
          $form->secondaryTabs['fields']['viewBag[heroPref]'] = [
              'tab'      => 'Hero',
              'type'     => 'switch',
              'label'    => 'Video Feature',
              'comment'  => 'If turned off, hero block will be changed to slider.',
              'cssClass' => 'secondary-tab ',
              'span'     => 'right'
          ];
          $form->secondaryTabs['fields']['viewBag[videoHeader]'] = [
              'tab'      => 'Hero',
              'type'     => 'text',
              'label'    => 'Header',
              'cssClass' => 'secondary-tab ',
              'span'     => 'full'
          ];
          $form->secondaryTabs['fields']['viewBag[videoTeaser]'] = [
              'tab'      => 'Hero',
              'type'     => 'textarea',
              'label'    => 'Teaser',
              'cssClass' => 'secondary-tab ',
              'span'     => 'full'
          ];
          $form->secondaryTabs['fields']['viewBag[videoPoster]'] = [
              'tab'      => 'Hero',
              'type'     => 'mediafinder',
              'mode'     => 'image',
              'label'    => 'Video Poster',
              'cssClass' => 'secondary-tab ',
              'span'     => 'full',
              'comment'  => '700px X 900px (Portrait)'
          ];
          $form->secondaryTabs['fields']['viewBag[videoTitles]'] = [
              'tab'      => 'Hero',
              'type'     => 'repeater',
              'label'    => 'Titles',
              'cssClass' => 'secondary-tab ',
              'span'     => 'full',
              'form'     => ['fields' => $videoTitle],
          ];
          $form->secondaryTabs['fields']['viewBag[videoSection]'] = [
              'tab'      => 'Hero',
              'type'     => 'section',
              'cssClass' => 'secondary-tab ',
              'span'     => 'full'
          ];
          $form->secondaryTabs['fields']['viewBag[slider]'] = [
              'tab'      => 'Hero',
              'type'     => 'repeater',
              'form'     => ['fields' => $fields],
              'cssClass' => 'secondary-tab ',
              'label'    => 'Slider'
          ];
          // For make the field translatable with RainLab.Translate plugin
          $form->model->translatable[] = 'viewBag[slider]';
        }
      });
    }
}
