<?php namespace Linus\Offices\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusOffices extends Migration
{
    public function up()
    {
        Schema::create('linus_offices_', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('email', 255);
            $table->string('location', 255);
            $table->string('waze', 500);
            $table->string('phone', 255);
            $table->string('phone2', 255)->nullable();
            $table->string('phone3', 255)->nullable();
            $table->integer('order_id');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_offices_');
    }
}
