<?php namespace Linus\Forms\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusFormsTasteful extends Migration
{
    public function up()
    {
        Schema::create('linus_forms_tasteful', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('email', 255);
            $table->string('number', 255);
            $table->string('message', 500);
            $table->dateTime('date_time');
            $table->string('unread', 11);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_forms_tasteful');
    }
}
