<?php namespace Linus\Forms\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusFormsPartners extends Migration
{
    public function up()
    {
        Schema::create('linus_forms_partners', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name', 255);
            $table->string('service', 255);
            $table->string('message', 255);
            $table->string('email', 255);
            $table->string('phone', 255)->nullable()->default('NULL');
            $table->string('country', 255)->nullable()->default('NULL');
            $table->string('address', 255)->nullable()->default('NULL');
            $table->string('company', 255)->nullable()->default('NULL');
            $table->timestamp('deleted_at')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_forms_partners');
    }
}
