<?php namespace Linus\Forms\Components;

use Cms\Classes\ComponentBase;
use Input;
use Validator;
use ValidationException;
use Redirect;
use Mail;
use Flash;
use Linus\Forms\Models\Tasteful;

class Tastefulform extends ComponentBase
{
    public function componentDetails()
    {
        return [
            'name'        => 'Tasteful Booking Form',
            'description' => 'Form for booking a food tasting'
        ];
    }

    public function defineProperties()
    {
        return [];
    }

    public function onSendTaste(){
        // Validation
        $data = post();
        $rules = [
            'Date' => 'required',
            'Name' => 'required',
            'Email' => 'required|email',
            'Phone' => 'required|numeric',
            'Message' => 'required'
        ]; 
        $validator = Validator::make($data, $rules);

        if($validator->fails()){
            throw new ValidationException($validator);
        }
        else{
            // Form Data
            $date = Input::get('Date');
            $name = Input::get('Name');
            $email = Input::get('Email');
            $number = Input::get('Phone');
            $message = Input::get('Message');

            // Add to DB
            $taste = new Tasteful();
            $taste->date_time = $date;
            $taste->name = $name;
            $taste->email = $email;
            $taste->number = $number;
            $taste->message = $message;
            $taste->save();

            //Send Email Notification
            $vars = [
                'vars' => $data,
            ];
            Mail::send('tastefulbook', $vars, function($message){
                $message->to('salesandmarketing.townsdelight@gmail.com', "Town's Delight - The Caterer")->bcc('matthew.rufino@gmail.com');
                //$message->to('matthew.rufino@gmail.com', "Town's Delight - The Caterer");
                $message->subject('Tasteful Booking | You have a new inquiry');
            });

            Mail::send('autorespond', $vars, function($message){
                $message->to( Input::get('Email'), Input::get('Name'));
                $message->subject('Thank you for filling out!');
            });

            Flash::success('Success!');
        }
    }
}
