<?php namespace Linus\Forms\Components;

use Cms\Classes\ComponentBase;
use Linus\Venues\Models\Venue as VenueList;
use Linus\Services\Models\Service as ServiceList;
use Input;
use Validator;
use ValidationException;
use Redirect;
use Mail;
use Flash;
use Linus\Forms\Models\Service as ServiceModel;

class Service extends ComponentBase
{
    public function componentDetails()
    {
        return [
            'name'        => 'Service Form',
            'description' => 'Form for service inside page'
        ];
    }

    public function defineProperties()
    {
        return [];
    }

    public function venues(){
        $venues = VenueList::select('name')->get();
        return [
            $venues
        ];
    }

    public function service(){
        $service = ServiceList::select('name')->get();
        return [
            $service
        ];
    }

    public function onSendForm(){
        // Validation
        $data = post();
        $rules = [
            'Date' => 'required',
            'Name' => 'required',
            'Email' => 'required|email',
            'Phone' => 'required|numeric',
            'Message' => 'required',
            'Capacity' => 'required|numeric',
            'Venue' => 'required',
            'Inquire' => 'required'
        ]; 
        $validator = Validator::make($data, $rules);

        if($validator->fails()){
            throw new ValidationException($validator);
        }
        else{
            // Form Data
            $date = Input::get('Date');
            $name = Input::get('Name');
            $email = Input::get('Email');
            $number = Input::get('Phone');
            $message = Input::get('Message');
            $capacity = Input::get('Capacity');
            $venue = Input::get('Venue');
            $inquire = Input::get('Inquire');

            // Add to DB
            $serv = new ServiceModel();
            $serv->event_date = $date;
            $serv->name = $name;
            $serv->email = $email;
            $serv->phone = $number;
            $serv->message = $message;
            $serv->capacity = $capacity;
            $serv->venue = $venue;
            $serv->service = $inquire;
            $serv->save();

            //Send Email Notification
            $vars = [
                'vars' => $data,
            ];

            Mail::send('serviceform', $vars, function($message){
                $message->to('salesandmarketing.townsdelight@gmail.com', "Town's Delight - The Caterer")->bcc('matthew.rufino@gmail.com');
                //$message->to('matthew.rufino@gmail.com', "Town's Delight - The Caterer");
                $message->subject('Services | You have a new inquiry');
            });

            Mail::send('autorespond', $vars, function($message){
                $message->to( Input::get('Email'), Input::get('Name'));
                $message->subject('Thank you for filling out!');
            });

            Flash::success('Success!');
        }
    }
}
