<?php namespace Linus\Forms\Components;

use Cms\Classes\ComponentBase;
use Input;
use Validator;
use ValidationException;
use Redirect;
use Mail;
use Flash;
use Linus\Forms\Models\Partner as ContactModel;

class Partner extends ComponentBase
{
    public function componentDetails()
    {
        return [
            'name'        => 'Membership Form',
            'description' => 'No description provided yet...'
        ];
    }

    public function defineProperties()
    {
        return [];
    }
    public function onSendForm(){
        // Validation
        $data = post();
        $rules = [
            'Name' => 'required',
            'Email' => 'required|email',
            'Message' => 'required',
            'Subject' => 'required',
            'Phone' => 'required',
        ];
        $validator = Validator::make($data, $rules);

        if($validator->fails()){
            throw new ValidationException($validator);
        }
        else{
            // Form Data
            $name = Input::get('Name');
            $email = Input::get('Email');
            $phone = Input::get('Phone');
            $company = Input::get('Company');
            $country = Input::get('Country');
            $address = Input::get('Address');
            $subject = Input::get('Subject');
            $message = Input::get('Message');

            // Add to DB
            $contact = new ContactModel();
            $contact->name = $name;
            $contact->email = $email;
            $contact->phone = $phone;
            $contact->company = $company;
            $contact->country = $country;
            $contact->address = $address;
            $contact->service = $subject;
            $contact->message = $message;
            $contact->save();

            //Send Email Notification
            $vars = [
                'vars' => $data,
            ];

            Mail::send('linusmail', $vars, function($message){
                $message->to('inquiry@mechatrends.com.ph', "Mechatrends Contractors Corporation");
                $message->subject('Membership Form | You have a new inquiry');
            });

            Mail::send('autorespond', $vars, function($message){
                $message->to( Input::get('Email'), Input::get('Name'));
                $message->subject('Thank you for filling out!');
            });

        }
    }
}
