<?php namespace Linus\Forms\Components;

use Cms\Classes\ComponentBase;
use Linus\Venues\Models\Venue as VenueList;
use Linus\Services\Models\Service as ServiceList;
use Input;
use Validator;
use ValidationException;
use Redirect;
use Mail;
use Flash;
use System\Models\File;
use Linus\Forms\Models\Fullmenu as Fullmenu;
use Linus\Forms\Models\Menu as MenuModel;

class Menu extends ComponentBase
{
    public function componentDetails()
    {
        return [
            'name'        => 'Menu Component',
            'description' => 'No description provided yet...'
        ];
    }

    public function defineProperties()
    {
        return [];
    }

    public function venues(){
        $venues = VenueList::select('name')->get();
        return [
            $venues
        ];
    }

    public function service(){
        $service = ServiceList::select('name')->get();
        return [
            $service
        ];
    }

    public function fullmenu(){
        $fullmenu = Fullmenu::get();
        return [
            $fullmenu->toArray()
        ];
    }
    
    public function onSendTaste(){
        // $menu = $this->fullmenu();
        // dd($menu[0][0]['fullmenu']);
        //Validation
        $data = post();
        $rules = [
            'Name' => 'required',
            'Email' => 'required|email',
            'Phone' => 'required|numeric',
            'Inquire' => 'required',
            'Venue' => 'required',
            'Date' => 'required',
        ]; 
        $validator = Validator::make($data, $rules);

        if($validator->fails()){
            throw new ValidationException($validator);
        }
        else{
            // Form Data
            $name = Input::get('Name');
            $email = Input::get('Email');
            $number = Input::get('Phone');
            $service = Input::get('Inquire');
            $venue = Input::get('Venue');
            $date = Input::get('Date');
            // $menu_name = Input::get('menu_name');
            // $menu_path = Input::get('menu_path');
            // $menu_extension = Input::get('menu_extension');

            // Add to DB
            $taste = new MenuModel();
            $taste->name = $name;
            $taste->email = $email;
            $taste->phone = $number;
            $taste->service = $service;
            $taste->venue = $venue;
            $taste->event_date = $date;
            $taste->save();

            //Send Email Notification
            $vars = [
                'vars' => $data,
            ];

            Mail::send('menuform', $vars, function($message){
                $message->to('salesandmarketing.townsdelight@gmail.com', "Town's Delight - The Caterer")->bcc('matthew.rufino@gmail.com');
                //$message->to('matthew.rufino@gmail.com', "Town's Delight - The Caterer")->bcc('matthew.rufino@gmail.com');
                $message->subject('Food Menu | You have a new inquiry');
            });

            Mail::send('autorespond', $vars, function($message){
                $message->to( Input::get('Email'), Input::get('Name'));
                $message->subject('Thank you for filling out!');
                // $message->attach(
                //     Input::get('menu_path'),
                //     [
                //         'as' => Input::get('menu_name'),
                //         'mime' => Input::get('menu_extension')
                //     ]
                // );
            });

            Flash::success('Success!');
        }
    }
}
