<?php namespace Linus\Forms\Components;

use Cms\Classes\ComponentBase;
use Linus\Services\Models\Service as ServiceList;
use Input;
use Validator;
use ValidationException;
use Redirect;
use Mail;
use Flash;
use System\Models\File;
use Linus\Forms\Models\Career as CareerModel;

class Careers extends ComponentBase
{
    public function componentDetails()
    {
        return [
            'name'        => 'Careers Component',
            'description' => 'No description provided yet...'
        ];
    }

    public function defineProperties()
    {
        return [];
    }

    public function onSendForm(){
        // Validation
        $data = post();
        $rules = [
            'Name' => 'required',
            'Email' => 'required|email',
            'Phone' => 'required',
            'Resume' => 'required|mimes:pdf,docx,doc',
        ];
        $validator = Validator::make(Input::all(), $rules);

        if($validator->fails()){
            throw new ValidationException($validator);
        }
        else{
            // Form Data
            $name = Input::get('Name');
            $email = Input::get('Email');
            $phone = Input::get('Phone');
            $resume = Input::file('Resume');
            $career = Input::get('Career');

            // Add to DB
            $serv = new CareerModel();
            $serv->name = $name;
            $serv->email = $email;
            $serv->contact = $phone;
            $serv->resume = $resume;
            $serv->job = $career;
            $serv->save();

            //Send Email Notification
            $vars = [
                'vars' => $data,
            ];

            Mail::send('linusmail', $vars, function($message){
                $attachFile = (new File())->fromPost(Input::file('Resume'));
                $message->to('hr@mechatrends.com.ph', "Mechatrends Contractors Corporation");
                $message->subject('Careers | You have a new inquiry');
                $message->attach(
                    $attachFile['path'],
                    [
                        'as' => $attachFile['file_name'],
                        'mime' => $attachFile['extension']
                    ]
                );
            });

            Mail::send('autorespond', $vars, function($message){
                $message->to( Input::get('Email'), Input::get('Name'));
                $message->subject('Thank you for filling out!');
            });

            // Flash::success('Success!');
        }
    }

    public function onFileUpload() {
        $resume = Input::all();

        $rules = [
            'Resume' => 'mimes:pdf,docx,doc',
        ];

        $validator = Validator::make($resume, $rules);

        if($validator->fails()){
            //throw new ValidationException($validator);
            return[
                '#file_name' => 'Please upload pdf, docx, or doc files.'
            ];
        }
        else{
            $file = (new File())->fromPost($resume['Resume']);
            return[
                '#file_name' => $file['file_name']
            ];
        }
    }
}
