<?php namespace Linus\Careers\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class BuilderTableCreateLinusCareers extends Migration
{
    public function up()
    {
        Schema::create('linus_careers_', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('career_id');
            $table->string('job', 255);
            $table->string('job_type', 255);
            $table->string('description', 255);
            $table->string('requirements', 255);
            $table->integer('display')->default(0);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('linus_careers_');
    }
}
